-----------------------------------------
--                                     --
-- @name: 	 Desktop                   --
-- @version: 0.1 Beta 3                --
-- @author:  SWAT                      --
-- @url:	 http://www.dc-swat.net.ru --
--                                     --
-----------------------------------------


if not Desktop then


Desktop = {

	font = nil,
	app = nil,
	sleep = false,
	
	apps = {
	
		panel = nil,
		list = {},
		
		pos = {

			x = 20,
			y = 20
		}
	
	}
}



function Desktop:CreateHighlight(src)

	local s = DS.GUI_SurfaceCreate("highlight_icon", DS.SDL_HWSURFACE, 48, 48, 16, 0, 0, 0, 0);
	
	DS.GUI_SurfaceFill(s, nil, DS.GUI_SurfaceMapRGB(s, 41, 177, 234));
	DS.GUI_SurfaceBlit(src, nil, s, nil);

	return s;
end



function Desktop:AppInList(name)

	
	for i = 1, table.getn(self.apps.list) do

		if self.apps.list[i] == name then
   			return true;
		end
	end
	
	return false;
end


function Desktop:AddToList(app)

    
	if app and app.name ~= "Main" and not self:AppInList(app.name) then
	
	    table.insert(self.apps.list, app.name);

	    local ts = DS.GUI_FontGetTextSize(self.font, app.name);

		local b = DS.GUI_ButtonCreate(app.name, self.apps.pos.x, self.apps.pos.y, 53 + ts.w, 48);
	    local s = DS.GUI_SurfaceLoad(app.icon);

	    if s ~= nil then

			DS.GUI_ButtonSetNormalImage(b, s);
			DS.GUI_ButtonSetHighlightImage(b, self:CreateHighlight(s));
			DS.GUI_ButtonSetPressedImage(b, s);
			DS.GUI_ButtonSetDisabledImage(b, s);

		end


		local c = DS.GUI_LuaCallbackCreate(self.app.id, string.format("Desktop:OpenApp(%d)", app.id));
		DS.GUI_ButtonSetClick(b, c);


		local l = DS.GUI_LabelCreate(app.name, 0, 0, ts.w + 53, 48, self.font, app.name);
		DS.GUI_LabelSetTextColor(l, 0, 0, 0);
		DS.GUI_WidgetSetAlign(l, DS.WIDGET_HORIZ_RIGHT);
		DS.GUI_WidgetSetAlign(l, DS.WIDGET_VERT_CENTER);

		DS.GUI_ButtonSetCaption(b, l);
	    DS.GUI_ContainerAdd(self.apps.panel, b);


		self.apps.pos.y = self.apps.pos.y + 56;

		if self.apps.pos.y >= 445 then
		    self.apps.pos.x = self.apps.pos.x + 200;
		    self.apps.pos.y = 20;
		end
	end
end



function Desktop:OpenApp(id)

	if id < 0 then
		return DS.ToggleConsole();
	end


	local app = DS.GetAppById(id);
	
	if app ~= nil then
	
		DS.CloseApp(Desktop.app, 0);
		self:Sleep();
		return DS.OpenApp(app);
		
	end
	
	return false;
end



function Desktop:BuildAppList(update)

--	print("Building app list...");
	
	if not update then

		self:AddToList({
			name = "Console",
			icon = GetWorkPath() .. "/gui/icons/normal/console.png",
			id = -1
		});
	
	end


	local applist = DS.GetAppList();
	
	if applist ~= nil then
	
		local item = DS.listGetItemFirst(applist);

		while item ~= nil do
	
			self:AddToList(DS.VoidToApp(item.data));
			item = DS.listGetItemNext(item);
		
		end
	
		return true;
	end
	
	return false;
end



function Desktop:ShowVersion()

	local ver = string.format("DreamShell %s", DS.GetVersion());
	local ts = DS.GUI_FontGetTextSize(self.font, ver);

	local b = DS.GUI_ButtonCreate("version", 640 - ts.w - 10, 480 - ts.h - 35, ts.w, ts.h);


	DS.GUI_ButtonSetNormalImage(b, NULL);
	DS.GUI_ButtonSetHighlightImage(b, NULL);
	DS.GUI_ButtonSetPressedImage(b, NULL);
	DS.GUI_ButtonSetDisabledImage(b, NULL);

	local l = DS.GUI_LabelCreate("version", 0, 0, ts.w, ts.h, self.font, ver);
	DS.GUI_LabelSetTextColor(l, 0, 0, 0);
	DS.GUI_WidgetSetAlign(l, DS.WIDGET_HORIZ_LEFT);
	DS.GUI_ButtonSetCaption(b, l);
    DS.GUI_ContainerAdd(self.apps.panel, b);

end



function Desktop:Start()
	print("Desktop: Sorry this function is not supported yet");
	DS.ToggleConsole();
end




function Desktop:Update()

    self:BuildAppList(true);
	self.sleep = false;
end


function Desktop:Sleep()
	self.sleep = true;
end



function Desktop:Initialize()

	if self.app == nil then
		
		self.app = DS.GetAppById(THIS_APP_ID);
		
		if self.app ~= nil then
	
	
	        local f = DS.listGetItemByName(self.app.resources, "arial");
	
			if f~= nil then
			    self.font = DS.GUI_AnyToFont(f.data);
			end
	
	
			local p = DS.listGetItemByName(self.app.elements, "applist");
	
			if p~= nil and self.font ~= nil then
			
			    self.apps.panel = DS.GUI_AnyToWidget(p.data);
			    self:BuildAppList(false);
			    self:ShowVersion();
			    
			end
			
		end
	end	  
end 



function Desktop:Shutdown()
	return true;
end



end