-----------------------------------------
--                                     --
-- @name: 	 Region Changer            --
-- @version: 1.8                       --
-- @author:  SWAT                      --
-- @url:	 http://www.dc-swat.ru     --
--                                     --
-----------------------------------------


if not RegionChanger then


	RegionChanger = {
		app = nil,
		pages = nil,
		progress = nil,
		swirl = nil,
		broadcast = {},
		country = {},
		lang = {},
		clear = {
			sys = nil,
			game = nil
		},
		data = nil,
		values = nil
	}

	
	function RegionChanger:ShowPage(index) 
		return DS.GUI_CardStackShowIndex(self.pages, index); 
	end
	
	
	function RegionChanger:SelectBroadcast(index) 
	
		for i = 1, table.getn(self.broadcast) do

			if i == index then
				
				--if not DS.GUI_WidgetGetState(self.broadcast[i]) then
					DS.GUI_WidgetSetState(self.broadcast[i], 1); 
					RC.flash_factory_set_broadcast(self.data, index);
				--end
				
			else
				DS.GUI_WidgetSetState(self.broadcast[i], 0); 
			end
			
			DS.GUI_WidgetUpdate(self.broadcast[i], 1);
		end
	end
	
	function RegionChanger:SelectCountry(index) 
		for i = 1, table.getn(self.country) do

			if i == index then
				
				--if not DS.GUI_WidgetGetState(self.country[i]) then
					DS.GUI_WidgetSetState(self.country[i], 1); 
					RC.flash_factory_set_country(self.data, index, DS.GUI_WidgetGetState(self.swirl));
				--end
				
			else
				DS.GUI_WidgetSetState(self.country[i], 0); 
			end
			
			DS.GUI_WidgetUpdate(self.country[i], 1);
		end
	end

	
	function RegionChanger:SelectLang(index) 
	
		for i = 1, table.getn(self.lang) do

			if i == index then
				
				--if not DS.GUI_WidgetGetState(self.lang[i]) then
					DS.GUI_WidgetSetState(self.lang[i], 1);
					RC.flash_factory_set_lang(self.data, index);					
				--end
				
			else
				DS.GUI_WidgetSetState(self.lang[i], 0); 
			end
			
			DS.GUI_WidgetUpdate(self.lang[i], 1);
		end
	end
	
	
	function RegionChanger:Read() 
	
		if self.data then
			RC.flash_factory_free_data(self.data);
			RC.flash_factory_free_values(self.values);
		end
	
		self.data = RC.flash_read_factory();
		self.values = RC.flash_factory_get_values(self.data);
		DS.GUI_WidgetSetState(self.swirl, self.values.black_swirl);
		DS.GUI_WidgetUpdate(self.swirl, 1);
		self:SelectCountry(self.values.country);
		self:SelectBroadcast(self.values.broadcast);
		self:SelectLang(self.values.lang);

	end
	
	
	function RegionChanger:Write() 
		RC.flash_write_factory(self.data);
	end
	
	
	function RegionChanger:Reboot() 
		DS.dsystem("dc -reboot");
	end
	
	
	function RegionChanger:ClearFlashrom()
		if DS.GUI_WidgetGetState(self.clear.sys) then
			RC.flash_clear(KOS.FLASHROM_PT_SETTINGS);
		end
		if DS.GUI_WidgetGetState(self.clear.game) then
			RC.flash_clear(KOS.FLASHROM_PT_BLOCK_1);
		end
	end
	
	
	function RegionChanger:ChangeProgress(p)
		DS.GUI_Lock();
		DS.GUI_ProgressBarSetPosition(self.progress, p);
		DS.GUI_Unlock();
		DS.GUI_TriggerUpdate();
	end
	
	function RegionChanger:CreateBackup()
	
		self:ChangeProgress(0.1);
		local file = GetWorkPath().."/shared/flash/flash_factory_backup.bin";
		
		if DS.FileExists(file) then
			KOS.fs_unlink(file);
		end
		
		local f = KOS.fs_open(file, KOS.O_WRONLY);
		self:ChangeProgress(0.2);
		local data = RC.flash_read_factory();
		self:ChangeProgress(0.4);
		
		if f > -1 then

			KOS.fs_write(f, data, 8192); 
			self:ChangeProgress(0.6);
			KOS.fs_close(f);
			RC.flash_factory_free_data(data);
			self:ChangeProgress(0.8);
		
		else
		
			file = "/ram/flash_backup.bin";
			f = KOS.fs_open(file, KOS.O_WRONLY);
		
			if DS.FileExists("/vmu/a1/FLASHBKP.BIN") then
				KOS.fs_unlink("/vmu/a1/FLASHBKP.BIN");
			elseif DS.FileExists("/vmu/a2/FLASHBKP.BIN") then
				KOS.fs_unlink("/vmu/a2/FLASHBKP.BIN");
			end

			KOS.fs_write(f, data, 8192); 
			self:ChangeProgress(0.6);
			KOS.fs_close(f);
			RC.flash_factory_free_data(data);
			self:ChangeProgress(0.8);

			if DS.dsystem("vmu -c -n -f "..file.." -o /vmu/a1/FLASHBKP.BIN -i Region Changer Backup") ~= DS.CMD_OK then
				DS.dsystem("vmu -c -n -f "..file.." -o /vmu/a2/FLASHBKP.BIN -i Region Changer Backup");
			end
			KOS.fs_unlink(file);
		end
		self:ChangeProgress(1.0);
	end
	
	
	function RegionChanger:RestoreBackup()
	
		self:ChangeProgress(0.1);
		
		local file = GetWorkPath().."/shared/flash/flash_factory_backup.bin";
		local f = KOS.fs_open(file, KOS.O_RDONLY);
		local data = RC.flash_read_factory();
		self:ChangeProgress(0.2);
		
		if f > -1 then
		
			self:ChangeProgress(0.4);
			KOS.fs_read(f, data, 8192); 
			self:ChangeProgress(0.6);
			KOS.fs_close(f);
			RC.flash_write_factory(data);
			self:ChangeProgress(0.8);
			RC.flash_factory_free_data(data);
			self:Read();
		
		else
			
			file = "/ram/flash_backup.bin";
			if not DS.dsystem("vmu -c -v -f "..file.." -o /vmu/a1/FLASHBKP.BIN") then
				DS.dsystem("vmu -c -v -f "..file.." -o /vmu/a2/FLASHBKP.BIN");
			end
			
			self:ChangeProgress(0.4);
			f = KOS.fs_open(file, KOS.O_RDONLY);
			
			self:ChangeProgress(0.6);
			KOS.fs_read(f, data, 8192); 
			self:ChangeProgress(0.8);
			KOS.fs_close(f);
			RC.flash_write_factory(data);
			self:ChangeProgress(0.9);
			RC.flash_factory_free_data(data);
			KOS.fs_unlink(file);
			self:Read();
		end
		self:ChangeProgress(1.0);
	end
	
	
	function RegionChanger:GetElement(name)
		local el = DS.listGetItemByName(self.app.elements, name);

		if el ~= nil then
			return DS.GUI_AnyToWidget(el.data);
		end
		return nil;
	end
	

	function RegionChanger:Initialize()

		if self.app == nil then
			
			self.app = DS.GetAppById(THIS_APP_ID);
			
			if self.app ~= nil then

				self.pages = self:GetElement("pages");
				self.progress = self:GetElement("backup-progress");
				self.swirl = self:GetElement("change-swirl-checkbox");
				self.clear.sys = self:GetElement("clear-sys-checkbox");
				self.clear.game = self:GetElement("clear-game-checkbox");
				
				table.insert(self.country, self:GetElement("change-country-japan-checkbox"));
				table.insert(self.country, self:GetElement("change-country-usa-checkbox"));
				table.insert(self.country, self:GetElement("change-country-europe-checkbox"));
				
				table.insert(self.broadcast, self:GetElement("change-ntsc-checkbox"));
				table.insert(self.broadcast, self:GetElement("change-pal-checkbox"));
				table.insert(self.broadcast, self:GetElement("change-palm-checkbox"));
				table.insert(self.broadcast, self:GetElement("change-paln-checkbox"));
				
				table.insert(self.lang, self:GetElement("change-lang-japan-checkbox"));
				table.insert(self.lang, self:GetElement("change-lang-english-checkbox"));
				table.insert(self.lang, self:GetElement("change-lang-german-checkbox"));
				table.insert(self.lang, self:GetElement("change-lang-french-checkbox"));
				table.insert(self.lang, self:GetElement("change-lang-spanish-checkbox"));
				table.insert(self.lang, self:GetElement("change-lang-italian-checkbox"));
				self:Read();
				
				return true;
			end
		end
	end 


	function RegionChanger:Shutdown()
		
		if self.app ~= nil then
			DS.CloseApp(self.app, 0);
			
			local app = DS.GetAppByName("Main");
			
			if app ~= nil then
				DS.OpenApp(app);
			end
		end
	end


end