----------------------------------------
--                                    --
-- @name: 	Startup script            --
-- @author: SWAT                      --
-- @url:	http://www.dc-swat.ru     --
--                                    --
----------------------------------------
--
-- Internal functions is only:
-- 
-- "system"          	 - DreamShell command line (if console initialized)
-- "InitModules"     	 - Initialize module system
-- "OpenModule"      	 - Open module
-- "GetWorkPath"     	 - Return current DreamShell work directory
-- "SetWorkPath"     	 - Seturn current DreamShell work directory
-- "SDFS_Init" 	     	 - Init SD Card filesystem
-- "SDFS_Shutdown"       - Shutdown SD Card filesystem
--
--



local DreamShell = {

	initialized = false,
	
	params = {
	
		screen = {
	
--			width = 768,
--			height = 576,
	
			width = 640,
			height = 480,
			bpp = 16,
			hz = 50,
			vert_wait = false,
			driver = "direct"
--			driver = "DMA"
		},
	
	 	logo = {
	 	
			show = false,
			ms = 2000,
			fade = 1 
		},
		
		modules = {
		 	zip = true,
			zipfs = false,
		 	bzip2 = true
		},
		
		console = {
		    debug = 0,
		    lines = 100,
		    opaque = 255
		}
	}
};



function DreamShell:Initialize()


	local width = self.params.screen.width;
	local height = self.params.screen.height;
	
	local wp = GetWorkPath();

--	print("Initializing Modules...")
	if not InitModules() then
	    print("DS_ERROR: Can't init modules.")
	    return false
	end

	
	if not DS then
		if not OpenModule(wp .. "/modules/lua/luaDS.klf") then
			return false
		end
	end
	
	
	DS.SetConsoleDebug(self.params.console.debug);
	

--	print("Initializing Events...")
	if not DS.InitEvents() then
	    print("DS_ERROR: Can't init events.")
	    return false
	end	
	

--	print("Initializing Threads...")
	if not DS.InitThreads() then
	    print("DS_ERROR: Can't init threads.")
	    return false
	end
	

--	print("Initializing Video...")
	if not self:InitVideo(width, height, self.params.screen.bpp) then
	    print("DS_ERROR: Can't init video.")
	    return false
	end
	

	if not DS.InitConsole(wp .. "/fonts/console.png", wp .. "/gui/back/console.png", self.params.console.lines, 0, 0, width, height, self.params.console.opaque) then
	    print("DS_ERROR: Can't init console.")
	    return false
	end
	
	print(string.format(" -----------[ DreamShell version: %s ]------------- ", DS.GetVersion()));
	

--	print("Initializing TTF...")
	if DS.TTF_Init() < 0 then
    	print("DS_ERROR: Can't init TTF.");
	end
	
	
--	print("Initializing GUI...")
	if not DS.InitGUI() then
    	print("DS_ERROR: Can't init GUI.");
	end
	

--	print("Initializing Apps...")
	if not DS.InitApps() then
	    print("DS_ERROR: Can't init apps.");
	    return false
	end
	
	
	DS.SetState(DS.DS_STATE_RUNNING);
    
    if self.params.modules.zip then
		DS.OpenModule(GetWorkPath() .. "/modules/compress/zip.klf");
    end
    
    if self.params.modules.bzip2 then
		DS.OpenModule(GetWorkPath() .. "/modules/compress/bzip2.klf");
    end

    if self.params.modules.zipfs then
		DS.OpenModule(GetWorkPath() .. "/modules/compress/zipfs.klf");
    end


--	DS.ToggleConsole()
--	SDL.GUI_ScreenSetBackground(SDL.GUI_GetScreen(), SDL.GUI_SurfaceLoad(wp .. "/gui/logo.png"));

	self:InstallingApps(wp .. "/apps");
	self:OpenMainApp();
	self.initialized = true;
	
	return true;
end




function DreamShell:InitVideo(width, height, bpp)

--	return DS.InitVideo(width, height, bpp)
--
--	local init_flags = 0;
--	local video_flags = 0;
--	local screen = nil;
--	
--	DS.SDL_DC_ShowAskHz(DS.SDL_FALSE);
--	
--		
--	if self.params.screen.hz == 50 then
--		DS.SDL_DC_Default60Hz(DS.SDL_FALSE);
--	elseif self.params.screen.hz == 60 then
--		DS.SDL_DC_Default60Hz(DS.SDL_TRUE);
--	else
--		DS.SDL_DC_ShowAskHz(DS.SDL_TRUE);
--	end
--	
--	
--	if self.params.screen.vert_wait then
--		DS.SDL_DC_VerticalWait(DS.SDL_TRUE);
--	else
--		DS.SDL_DC_VerticalWait(DS.SDL_FALSE);
--	end
--	
--    
--	if self.params.screen.driver == "direct" then
--		DS.SDL_DC_SetVideoDriver(DS.SDL_DC_DIRECT_VIDEO);
--	elseif self.params.screen.driver == "DMA" then 
--    	DS.SDL_DC_SetVideoDriver(DS.SDL_DC_DMA_VIDEO);
--    else
--    	DS.SDL_DC_SetVideoDriver(DS.SDL_DC_DIRECT_VIDEO);
--    end
--    
--
--	init_flags = DS.bit_or(DS.SDL_INIT_VIDEO, DS.SDL_INIT_JOYSTICK);
--	video_flags = DS.bit_or(DS.SDL_HWSURFACE, DS.SDL_DOUBLEBUF);
--
--
--	if DS.SDL_Init(init_flags) < 0 then
--		print(string.format("SDL init failed: %s", DS.SDL_GetError()));
--        return false;
--	end
--
--    screen = DS.SDL_SetVideoMode(width, height, bpp, video_flags)
--
--    if not screen then
--         print(string.format("Change video mode failed: %s", DS.SDL_GetError()));
--         return false;
--	end
--	
--	
--	DS.SetScreen(screen);

	DS.SDL_JoystickOpen(0);
    DS.SDL_JoystickEventState(DS.SDL_ENABLE);
    DS.SDL_EnableUNICODE(DS.SDL_ENABLE);
	DS.SDL_ShowCursor(DS.SDL_DISABLE);

	if DS.PeriphExists("Mouse") == 0 then
		DS.SDL_DC_EmulateMouse(DS.SDL_TRUE);
	end
	
	if DS.PeriphExists("Keyboard") == 0 then

	    DS.SDL_DC_EmulateKeyboard(DS.SDL_TRUE);

	    DS.SDL_DC_MapKey(0, DS.SDL_DC_START, DS.SDLK_RETURN);
		DS.SDL_DC_MapKey(0, DS.SDL_DC_A, DS.SDLK_F15);
		DS.SDL_DC_MapKey(0, DS.SDL_DC_B, DS.SDLK_BACKSPACE);
		DS.SDL_DC_MapKey(0, DS.SDL_DC_X, DS.SDLK_F3);
		DS.SDL_DC_MapKey(0, DS.SDL_DC_Y, DS.SDLK_RETURN);

		DS.SDL_DC_MapKey(0, DS.SDL_DC_L, DS.SDLK_F2);
		DS.SDL_DC_MapKey(0, DS.SDL_DC_R, DS.SDLK_F1);

		DS.SDL_DC_MapKey(0, DS.SDL_DC_LEFT, DS.SDLK_LEFT);
		DS.SDL_DC_MapKey(0, DS.SDL_DC_RIGHT, DS.SDLK_RIGHT);
		DS.SDL_DC_MapKey(0, DS.SDL_DC_UP, DS.SDLK_UP);
		DS.SDL_DC_MapKey(0, DS.SDL_DC_DOWN, DS.SDLK_DOWN);
	
	else
	    DS.SDL_DC_EmulateKeyboard(DS.SDL_FALSE);
	end
	

	if self.params.logo.show then
		DS.ShowIMG(GetWorkPath() .. "/gui/logo.png", 0, 0, self.params.logo.ms, self.params.logo.fade);
	end

    return true;
end





function DreamShell:InstallingApps(dir)

    if not KOS then
		if not DS.OpenModule(GetWorkPath() .. "/modules/lua/luaKOS.klf") then
			return false
		end
	end
    
	local hnd = KOS.fs_open(dir, DS.bit_or(KOS.O_RDONLY, KOS.O_DIR));
	
	if hnd < 0 then
		return false
	end
	
	
	local ent = true;
	local app = nil;
	
	
	while (ent) do
	
		ent = KOS.fs_readdir(hnd)
		
		if ent ~= nil and ent.name ~= ".." and ent.name ~= "." and ent.name ~= ".svn" and ent.size < 0 then

			app = DS.AddApp(string.format("%s/%s/app.xml", dir, ent.name))
			
			if app ~= nil then
				print(string.format("DS_OK: Installed app %s %s (ID=%d)", app.name, app.fn, app.id))
			else
				print(string.format("DS_ERROR: Can't add app %s/%s/app.xml", dir, ent.name))
			end
		
		end
	end
	
	KOS.fs_close(hnd);
	return true;
end




function DreamShell:OpenMainApp()

	local app = DS.GetAppByName("Main");
	
	if not app or not DS.OpenApp(app) then
		print("DS_ERROR: Can't open Main app");
		DS.ShowConsole();
	end
end




if not DreamShell:Initialize() then

	print("DS_FATAL_ERROR: Can't startup DreamShell, exiting...");
	
	if DS then 
		DS.SetState(DS.DS_STATE_SHUTDOWN);
	else
		dofile(GetWorkPath() .. "/lua/shutdown.lua"); 
	end
end
